<?php
namespace App\Controllers;

use App\Models\Fixture;
use App\Models\Team;
use App\Models\MatchModel;

class FixtureController {
    public static function index() {
        require_login();
        $tid = intval($_GET['tid'] ?? 0); $teams = $tid ? \App\Models\TournamentTeam::listTeams($tid) : Team::all();
        $matches = MatchModel::all();
        view('fixtures/index', compact('teams','matches','tid'));
    }

    public static function generate() {
        require_login();
        $tid = intval($_POST['tournament_id'] ?? 0); $teamIds = $_POST['team_ids'] ?? [];
        if (count($teamIds) < 2) {
            $error = 'Seleccione al menos dos equipos';
            $tid = intval($_GET['tid'] ?? 0); $teams = $tid ? \App\Models\TournamentTeam::listTeams($tid) : Team::all();
            $matches = MatchModel::all();
            view('fixtures/index', compact('teams','matches','error','tid'));
            return;
        }
        Fixture::generateRoundRobin($teamIds, $tid);
        redirect('fixtures');
    }

    public static function saveResult() {
        require_login();
        $match_id = (int)($_POST['match_id'] ?? 0);
        $home_goals = (int)($_POST['home_goals'] ?? 0);
        $away_goals = (int)($_POST['away_goals'] ?? 0);
        MatchModel::setResult($match_id, $home_goals, $away_goals);
        redirect('fixtures');
    }
}
