<?php
namespace App\Models;

class MatchModel {
    public static function createWithStage($home, $away, $round, $stage, $leg=1, $tournament_id=null) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT INTO matches(home_team_id, away_team_id, round, stage, leg) VALUES (?,?,?,?,?)");
        $stmt->execute([$home, $away, $round, $stage, $leg]);
        if ($tournament_id !== null) {
            $id = $pdo->lastInsertId();
            $pdo->prepare("UPDATE matches SET tournament_id=? WHERE id=?")->execute([$tournament_id, $id]);
        }
    }

    public static function all($tournament_id = null) {
        $pdo = Database::conn();
        if ($tournament_id !== null) {
            $stmt = $pdo->prepare("SELECT m.*, h.name AS home_name, a.name AS away_name
                            FROM matches m
                            JOIN teams h ON h.id = m.home_team_id
                            JOIN teams a ON a.id = m.away_team_id
                            WHERE stage='league' AND m.tournament_id = ?
                            ORDER BY round, id");
            $stmt->execute([$tournament_id]);
            return $stmt->fetchAll();
        }
        return $pdo->query("SELECT m.*, h.name AS home_name, a.name AS away_name
                            FROM matches m
                            JOIN teams h ON h.id = m.home_team_id
                            JOIN teams a ON a.id = m.away_team_id
                            WHERE stage='league' AND (m.tournament_id = (:tid) OR :tid IS NULL)
                            ORDER BY round, id")->fetchAll();
    }
    public static function count() {
        $pdo = Database::conn();
        return (int)$pdo->query("SELECT COUNT(*) c FROM matches")->fetch()['c'];
    }
    public static function create($home, $away, $round, $tournament_id = null) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT INTO matches(home_team_id, away_team_id, round, stage, leg) VALUES (?,?,?,?,1)");
        $stmt->execute([$home, $away, $round, 'league']);
        if ($tournament_id !== null) {
            $id = $pdo->lastInsertId();
            $pdo->prepare("UPDATE matches SET tournament_id=? WHERE id=?")->execute([$tournament_id, $id]);
        }
    }
    public static function setResult($id, $hg, $ag) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("UPDATE matches SET home_goals=?, away_goals=?, played_at=NOW() WHERE id=?");
        $stmt->execute([$hg, $ag, $id]);
        \\App\\Models\\Suspension::onMatchCompleted($id);
    }
}
