<?php
namespace App\Models;

class TournamentTeam {
    public static function listTeams($tournament_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT tt.*, te.name, te.short_name FROM tournament_teams tt JOIN teams te ON te.id=tt.team_id WHERE tt.tournament_id=? ORDER BY te.name");
        $stmt->execute([$tournament_id]);
        return $stmt->fetchAll();
    }
    public static function add($tournament_id, $team_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("INSERT IGNORE INTO tournament_teams(tournament_id, team_id) VALUES (?,?)");
        $stmt->execute([$tournament_id, $team_id]);
    }
    public static function remove($tournament_id, $team_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("DELETE FROM tournament_teams WHERE tournament_id=? AND team_id=?");
        $stmt->execute([$tournament_id, $team_id]);
    }
    public static function teamIds($tournament_id) {
        $pdo = Database::conn();
        $stmt = $pdo->prepare("SELECT team_id FROM tournament_teams WHERE tournament_id=?");
        $stmt->execute([$tournament_id]);
        return array_map('intval', array_column($stmt->fetchAll(), 'team_id'));
    }
}
