<?php if (!empty($_SESSION['flash_error'])){ echo '<div class="alert alert-danger">'.htmlspecialchars($_SESSION['flash_error']).'</div>'; unset($_SESSION['flash_error']); } ?>
<h3>Partido: <?= htmlspecialchars($match['home_name']) ?> vs <?= htmlspecialchars($match['away_name']) ?></h3>
<p><strong>Marcador:</strong> <?= (int)$match['home_goals'] ?> - <?= (int)$match['away_goals'] ?> · <em>(Se recalcula desde eventos)</em></p>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header bg-light"><strong>Alineación <?= htmlspecialchars($match['home_name']) ?></strong></div>
      <div class="card-body">
        <?php $suspH = \App\Models\Suspension::listForMatchAndTeam($match['id'], $match['home_team_id']); if ($suspH): ?>
        <div class="alert alert-warning p-2"><strong>Suspendidos:</strong> <?php foreach($suspH as $s){ echo htmlspecialchars($s['name']).' '; } ?></div>
        <?php endif; ?>
        <form class="row g-2 mb-3" method="post" action="index.php?r=match_lineup_add">
          <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
          <input type="hidden" name="team_id" value="<?= $match['home_team_id'] ?>">
          <div class="col-7">
            <select name="player_id" class="form-select">
              <?php foreach ($home_players as $p): ?>
                <option value="<?= $p['id'] ?>"><?= htmlspecialchars(($p['number']?('#'.$p['number'].' '):'').$p['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-3">
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" name="is_starter" id="hs">
              <label class="form-check-label" for="hs">Titular</label>
            </div>
          </div>
          <div class="col-2"><button class="btn btn-success w-100">Añadir</button></div>
        </form>

        <table class="table table-sm">
          <thead><tr><th>N°</th><th>Jugador</th><th>Ini</th><th>Sale</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($home_lineup as $l): ?>
            <tr>
              <td><?= htmlspecialchars($l['number']) ?></td>
              <td><?= htmlspecialchars($l['name']) ?> <?= $l['is_starter']?'(Titular)':'' ?></td>
              <td><?= htmlspecialchars($l['minute_in']) ?></td>
              <td><?= htmlspecialchars($l['minute_out']) ?></td>
              <td>
                <form method="post" action="index.php?r=match_lineup_remove" onsubmit="return confirm('Quitar del acta?')">
                  <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
                  <input type="hidden" name="player_id" value="<?= $l['player_id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Quitar</button>
                </form>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="card">
      <div class="card-header bg-light"><strong>Alineación <?= htmlspecialchars($match['away_name']) ?></strong></div>
      <div class="card-body">
        <form class="row g-2 mb-3" method="post" action="index.php?r=match_lineup_add">
          <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
          <input type="hidden" name="team_id" value="<?= $match['away_team_id'] ?>">
          <div class="col-7">
            <select name="player_id" class="form-select">
              <?php foreach ($away_players as $p): ?>
                <option value="<?= $p['id'] ?>"><?= htmlspecialchars(($p['number']?('#'.$p['number'].' '):'').$p['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-3">
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" name="is_starter" id="as">
              <label class="form-check-label" for="as">Titular</label>
            </div>
          </div>
          <div class="col-2"><button class="btn btn-success w-100">Añadir</button></div>
        </form>

        <table class="table table-sm">
          <thead><tr><th>N°</th><th>Jugador</th><th>Ini</th><th>Sale</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($away_lineup as $l): ?>
            <tr>
              <td><?= htmlspecialchars($l['number']) ?></td>
              <td><?= htmlspecialchars($l['name']) ?> <?= $l['is_starter']?'(Titular)':'' ?></td>
              <td><?= htmlspecialchars($l['minute_in']) ?></td>
              <td><?= htmlspecialchars($l['minute_out']) ?></td>
              <td>
                <form method="post" action="index.php?r=match_lineup_remove" onsubmit="return confirm('Quitar del acta?')">
                  <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
                  <input type="hidden" name="player_id" value="<?= $l['player_id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Quitar</button>
                </form>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<div class="card mt-3">
  <div class="card-header bg-dark text-white">Eventos del partido</div>
  <div class="card-body">
    <form class="row g-2 align-items-end mb-3" method="post" action="index.php?r=match_event_add">
      <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
      <div class="col-md-1"><input type="number" name="minute" class="form-control" placeholder="Min" required></div>
      <div class="col-md-2">
        <select name="team_id" class="form-select" required>
          <option value="<?= $match['home_team_id'] ?>"><?= htmlspecialchars($match['home_name']) ?></option>
          <option value="<?= $match['away_team_id'] ?>"><?= htmlspecialchars($match['away_name']) ?></option>
        </select>
      </div>
      <div class="col-md-3">
        <select name="player_id" class="form-select">
          <option value="">Jugador (opcional)</option>
          <?php foreach (array_merge($home_players,$away_players) as $p): ?>
            <option value="<?= $p['id'] ?>"><?= htmlspecialchars(($p['number']?('#'.$p['number'].' '):'').$p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <select name="type" class="form-select">
          <option value="goal">Gol</option>
          <option value="penalty_goal">Gol de penal</option>
          <option value="own_goal">Autogol</option>
          <option value="yellow">Amarilla</option>
          <option value="red">Roja</option>
          <option value="sub_in">Entra</option>
          <option value="sub_out">Sale</option>
        </select>
      </div>
      <div class="col-md-3">
        <select name="related_player_id" class="form-select">
          <option value="">Relacionado (ej. cambia por / asist.)</option>
          <?php foreach (array_merge($home_players,$away_players) as $p): ?>
            <option value="<?= $p['id'] ?>"><?= htmlspecialchars(($p['number']?('#'.$p['number'].' '):'').$p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-1"><button class="btn btn-primary w-100">Agregar</button></div>
      <div class="col-12 mt-2">
        <input name="notes" class="form-control" placeholder="Notas (opcional)">
      </div>
    </form>

    <table class="table table-sm">
      <thead><tr><th>Min</th><th>Equipo</th><th>Jugador</th><th>Evento</th><th>Relacionado</th><th>Notas</th><th></th></tr></thead>
      <tbody>
        <?php foreach ($events as $e): ?>
          <tr>
            <td><?= (int)$e['minute'] ?></td>
            <td><?= htmlspecialchars($e['team_name']) ?></td>
            <td><?= htmlspecialchars($e['player_name']) ?></td>
            <td><?= htmlspecialchars($e['type']) ?></td>
            <td><?= htmlspecialchars($e['related_name']) ?></td>
            <td><?= htmlspecialchars($e['notes']) ?></td>
            <td>
              <form method="post" action="index.php?r=match_event_delete" onsubmit="return confirm('Eliminar evento?')">
                <input type="hidden" name="id" value="<?= $e['id'] ?>">
                <input type="hidden" name="match_id" value="<?= $match['id'] ?>">
                <button class="btn btn-sm btn-outline-danger">Eliminar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
