<h3>Fixture</h3>
<form class="mb-3" method="get" action="index.php">
  <input type="hidden" name="r" value="fixtures">
  <div class="row g-2 align-items-end">
    <div class="col-md-6">
      <label class="form-label">Torneo (ID)</label>
      <input type="number" name="tid" class="form-control" value="<?= (int)$tid ?>" placeholder="ID del torneo">
    </div>
    <div class="col-md-2">
      <button class="btn btn-outline-secondary w-100">Cambiar</button>
    </div>
    <div class="col-md-4 text-end">
      <a class="btn btn-outline-primary" href="index.php?r=tournament_setup&tid=<?= (int)$tid ?>">Config torneo</a>
    </div>
  </div>
</form>
<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="post" action="index.php?r=fixtures_generate" class="card p-3 mb-4">
  <input type="hidden" name="tournament_id" value="<?= (int)$tid ?>">
  <label class="form-label">Seleccione equipos (mínimo 2):</label>
  <div class="row">
    <?php foreach ($teams as $t): ?>
      <div class="col-md-3">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" name="team_ids[]" value="<?= $t['id'] ?>" id="t<?= $t['id'] ?>">
          <label class="form-check-label" for="t<?= $t['id'] ?>"><?= htmlspecialchars($t['name']) ?></label>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
  <button class="btn btn-primary mt-3">Generar todos contra todos</button>
</form>

<h4>Partidos</h4>
<table class="table table-bordered">
  <thead><tr><th>#</th><th>Jornada</th><th>Local</th><th>Visitante</th><th>Resultado</th><th>Acta</th></tr></thead>
  <tbody>
    <?php foreach ($matches as $m): ?>
      <tr>
        <td><?= $m['id'] ?></td>
        <td><?= $m['round'] ?></td>
        <td><?= htmlspecialchars($m['home_name']) ?></td>
        <td><?= htmlspecialchars($m['away_name']) ?></td>
        <td>
          <form method="post" action="index.php?r=fixtures_result" class="d-flex gap-1">
            <input type="hidden" name="match_id" value="<?= $m['id'] ?>">
            <input type="number" name="home_goals" value="<?= (int)$m['home_goals'] ?>" class="form-control form-control-sm" style="width:80px">
            <span class="mx-1">-</span>
            <input type="number" name="away_goals" value="<?= (int)$m['away_goals'] ?>" class="form-control form-control-sm" style="width:80px">
            <button class="btn btn-sm btn-success">Guardar</button>
          </form>
        </td>
        <td><a class="btn btn-sm btn-outline-primary" href="index.php?r=match_detail&id=<?= $m['id'] ?>">Acta</a></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
