<h3>Jugadores por equipo</h3>
<form method="get" action="index.php" class="row g-2 mb-3">
  <input type="hidden" name="r" value="players">
  <div class="col-md-6">
    <label class="form-label">Equipo</label>
    <select name="team_id" class="form-select" onchange="this.form.submit()">
      <option value="">-- Selecciona --</option>
      <?php foreach ($teams as $t): ?>
        <option value="<?= $t['id'] ?>" <?= ($team_id==$t['id'])?'selected':'' ?>><?= htmlspecialchars($t['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</form>

<?php if ($team_id): ?>
<div class="card mb-3">
  <div class="card-header">Nuevo jugador</div>
  <div class="card-body">
    <form method="post" action="index.php?r=players_store" class="row g-2">
      <input type="hidden" name="team_id" value="<?= (int)$team_id ?>">
      <div class="col-md-4"><input class="form-control" name="name" placeholder="Nombre" required></div>
      <div class="col-md-2"><input type="number" class="form-control" name="number" placeholder="N°"></div>
      <div class="col-md-3">
        <select name="position" class="form-select">
          <option value="">Posición</option>
          <option value="GK">GK</option>
          <option value="DF">DF</option>
          <option value="MF">MF</option>
          <option value="FW">FW</option>
        </select>
      </div>
      <div class="col-md-3"><button class="btn btn-success w-100">Agregar</button></div>
    </form>
  </div>
</div>

<table class="table table-striped table-sm">
  <thead><tr><th>#</th><th>N°</th><th>Nombre</th><th>Pos.</th><th>Acción</th></tr></thead>
  <tbody>
    <?php foreach ($players as $p): ?>
      <tr>
        <td><?= $p['id'] ?></td>
        <td><?= htmlspecialchars($p['number']) ?></td>
        <td><?= htmlspecialchars($p['name']) ?></td>
        <td><?= htmlspecialchars($p['position']) ?></td>
        <td>
          <form method="post" action="index.php?r=players_delete" onsubmit="return confirm('Eliminar jugador?')">
            <input type="hidden" name="id" value="<?= $p['id'] ?>">
            <input type="hidden" name="team_id" value="<?= (int)$team_id ?>">
            <button class="btn btn-sm btn-outline-danger">Eliminar</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php endif; ?>
