<?php
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/';
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    if (file_exists($file)) require $file;
});

session_start();

function view($template, $data = []) {
    extract($data);
    include __DIR__ . '/Views/layouts/header.php';
    include __DIR__ . '/Views/' . $template . '.php';
    include __DIR__ . '/Views/layouts/footer.php';
}

function redirect($route) {
    $url = (require __DIR__ . '/../config/config.php')['app']['url'];
    header('Location: ' . $url . 'public/index.php?r=' . $route);
    exit;
}

function auth() {
    return $_SESSION['user'] ?? null;
}

function require_login() {
    if (!auth()) redirect('login');
}
